/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketAnimation;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IntHashMap;
import net.minecraft.world.WorldServer;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.constants.EntityType;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.IEntityLivingBase;
import noppes.npcs.api.entity.data.IMark;
import noppes.npcs.api.entity.data.INpcAttribute;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.mixin.entity.IEntityTrackerMixin;
import noppes.npcs.api.wrapper.EntityWrapper;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.api.wrapper.data.AttributeWrapper;
import noppes.npcs.controllers.data.MarkData;
import noppes.npcs.reflection.entity.ai.attributes.AbstractAttributeMapReflection;

public class EntityLivingBaseWrapper<T extends EntityLivingBase>
extends EntityWrapper<T>
implements IEntityLivingBase {
    public EntityLivingBaseWrapper(T entity) {
        super(entity);
    }

    @Override
    public INpcAttribute addAttribute(INpcAttribute attribute) {
        if (attribute == null || this.hasAttribute(attribute)) {
            return null;
        }
        IAttribute attr = null;
        if (attribute.getMCAttribute() instanceof IAttribute) {
            attr = (IAttribute)attribute.getMCAttribute();
        } else if (attribute.getMCBaseAttribute() != null) {
            attr = attribute.getMCBaseAttribute();
        }
        if (attr == null) {
            return null;
        }
        ((EntityLivingBase)this.entity).func_110140_aT().func_111150_b(attr);
        INpcAttribute npcAttr = this.getIAttribute(attribute.getName());
        if (npcAttr != null) {
            ((AttributeWrapper)npcAttr).setCustom(true);
        }
        return npcAttr;
    }

    @Override
    public INpcAttribute addAttribute(String attributeName, String displayName, double baseValue, double minValue, double maxValue) {
        if (attributeName == null || attributeName.isEmpty() || this.hasAttribute(attributeName)) {
            return null;
        }
        return this.addAttribute(new AttributeWrapper((EntityLivingBase)this.entity, attributeName, displayName, baseValue, minValue, maxValue));
    }

    @Override
    public IMark addMark(int type) {
        MarkData data = MarkData.get((EntityLivingBase)this.entity);
        return data.addMark(type);
    }

    @Override
    public void addPotionEffect(int effect, int duration, int strength, boolean hideParticles) {
        Potion p = Potion.func_188412_a((int)effect);
        if (p == null) {
            return;
        }
        if (strength < 0) {
            strength = 0;
        } else if (strength > 255) {
            strength = 255;
        }
        if (duration < 0) {
            duration = 0;
        } else if (duration > 1000000) {
            duration = 1000000;
        }
        if (!p.func_76403_b()) {
            duration *= 20;
        }
        if (duration == 0) {
            ((EntityLivingBase)this.entity).func_184589_d(p);
        } else {
            ((EntityLivingBase)this.entity).func_70690_d(new PotionEffect(p, duration, strength, false, hideParticles));
        }
    }

    public boolean canSeeEntity(IEntity entity) {
        return ((EntityLivingBase)this.entity).func_70685_l(entity.getMCEntity());
    }

    @Override
    public void clearPotionEffects() {
        ((EntityLivingBase)this.entity).func_70674_bp();
    }

    @Override
    public IItemStack getArmor(int slot) {
        if (slot < 0 || slot > 3) {
            throw new CustomNPCsException("Wrong slot id:" + slot, new Object[0]);
        }
        EntityEquipmentSlot s = this.getSlot(slot);
        if (s == null) {
            return ItemStackWrapper.AIR;
        }
        return Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(((EntityLivingBase)this.entity).func_184582_a(s));
    }

    private int getArmSwingAnimationEnd() {
        if (((EntityLivingBase)this.entity).func_70644_a(MobEffects.field_76422_e)) {
            return 6 - (1 + Objects.requireNonNull(((EntityLivingBase)this.entity).func_70660_b(MobEffects.field_76422_e)).func_76458_c());
        }
        return ((EntityLivingBase)this.entity).func_70644_a(MobEffects.field_76419_f) ? 6 + (1 + Objects.requireNonNull(((EntityLivingBase)this.entity).func_70660_b(MobEffects.field_76419_f)).func_76458_c()) * 2 : 6;
    }

    public IEntityLivingBase getAttackTarget() {
        return (IEntityLivingBase)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)((EntityLivingBase)this.entity).func_70643_av());
    }

    @Override
    public float getHealth() {
        return ((EntityLivingBase)this.entity).func_110143_aJ();
    }

    @Override
    public INpcAttribute getIAttribute(String attributeName) {
        Map<String, IAttributeInstance> attributesByName = AbstractAttributeMapReflection.getAttributesByName(((EntityLivingBase)this.entity).func_110140_aT());
        if (attributesByName == null) {
            return null;
        }
        return Objects.requireNonNull(NpcAPI.Instance()).getIAttribute(attributesByName.get(attributeName));
    }

    @Override
    public String[] getIAttributeNames() {
        Map<String, IAttributeInstance> attributesByName = AbstractAttributeMapReflection.getAttributesByName(((EntityLivingBase)this.entity).func_110140_aT());
        if (attributesByName == null) {
            return new String[0];
        }
        return attributesByName.keySet().toArray(new String[0]);
    }

    @Override
    public INpcAttribute[] getIAttributes() {
        ArrayList<INpcAttribute> list = new ArrayList<INpcAttribute>();
        for (IAttributeInstance attr : ((EntityLivingBase)this.entity).func_110140_aT().func_111146_a()) {
            list.add(Objects.requireNonNull(NpcAPI.Instance()).getIAttribute(attr));
        }
        return list.toArray(new INpcAttribute[0]);
    }

    public IEntityLivingBase getLastAttacked() {
        return (IEntityLivingBase)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)((EntityLivingBase)this.entity).func_110144_aD());
    }

    @Override
    public int getLastAttackedTime() {
        return ((EntityLivingBase)this.entity).func_142013_aG();
    }

    @Override
    public IItemStack getMainhandItem() {
        return Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(((EntityLivingBase)this.entity).func_184614_ca());
    }

    @Override
    public IMark[] getMarks() {
        MarkData data = MarkData.get((EntityLivingBase)this.entity);
        return data.marks.toArray(new IMark[0]);
    }

    @Override
    public float getMaxHealth() {
        return ((EntityLivingBase)this.entity).func_110138_aP();
    }

    @Override
    public float getMoveForward() {
        return ((EntityLivingBase)this.entity).field_191988_bg;
    }

    @Override
    public float getMoveStrafing() {
        return ((EntityLivingBase)this.entity).field_70702_br;
    }

    @Override
    public float getMoveVertical() {
        return ((EntityLivingBase)this.entity).field_70701_bs;
    }

    @Override
    public IItemStack getOffhandItem() {
        return Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(((EntityLivingBase)this.entity).func_184592_cb());
    }

    @Override
    public int getPotionEffect(int effect) {
        PotionEffect pf = ((EntityLivingBase)this.entity).func_70660_b(Objects.requireNonNull(Potion.func_188412_a((int)effect)));
        if (pf == null) {
            return -1;
        }
        return pf.func_76458_c();
    }

    private EntityEquipmentSlot getSlot(int slot) {
        if (slot == 3) {
            return EntityEquipmentSlot.HEAD;
        }
        if (slot == 2) {
            return EntityEquipmentSlot.CHEST;
        }
        if (slot == 1) {
            return EntityEquipmentSlot.LEGS;
        }
        if (slot == 0) {
            return EntityEquipmentSlot.FEET;
        }
        return null;
    }

    @Override
    public int getType() {
        return EntityType.LIVING.get();
    }

    @Override
    public boolean hasAttribute(INpcAttribute attribute) {
        for (IAttributeInstance attr : ((EntityLivingBase)this.entity).func_110140_aT().func_111146_a()) {
            if (!attr.equals(attribute.getMCAttribute())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasAttribute(String attributeName) {
        Map<String, IAttributeInstance> attributesByName = AbstractAttributeMapReflection.getAttributesByName(((EntityLivingBase)this.entity).func_110140_aT());
        if (attributesByName == null) {
            return false;
        }
        return attributesByName.containsKey(attributeName);
    }

    @Override
    public boolean isAttacking() {
        return ((EntityLivingBase)this.entity).func_70643_av() != null;
    }

    @Override
    public boolean isChild() {
        return ((EntityLivingBase)this.entity).func_70631_g_();
    }

    @Override
    public boolean removeAttribute(INpcAttribute attribute) {
        if (attribute == null || !attribute.isCustom() || !this.hasAttribute(attribute)) {
            return false;
        }
        Map<IAttribute, IAttributeInstance> attributes = AbstractAttributeMapReflection.getAttributes(((EntityLivingBase)this.entity).func_110140_aT());
        Map<String, IAttributeInstance> attributesByName = AbstractAttributeMapReflection.getAttributesByName(((EntityLivingBase)this.entity).func_110140_aT());
        Multimap<IAttribute, IAttribute> descendantsByParent = AbstractAttributeMapReflection.getDescendantsByParent(((EntityLivingBase)this.entity).func_110140_aT());
        if (attributes == null || descendantsByParent == null || attributesByName == null) {
            return false;
        }
        IAttribute key = null;
        String name = null;
        IAttribute parent = null;
        for (IAttribute k : attributes.keySet()) {
            if (!attributes.get(k).equals(attribute.getMCAttribute())) continue;
            key = k;
            break;
        }
        if (key != null) {
            name = key.func_111108_a();
            for (IAttribute p : descendantsByParent.keySet()) {
                if (!descendantsByParent.get((Object)p).equals(key)) continue;
                parent = p;
                break;
            }
        }
        attributes.remove(key);
        attributesByName.remove(name);
        if (parent != null) {
            descendantsByParent.remove(parent, (Object)key);
        }
        return true;
    }

    @Override
    public boolean removeAttribute(String attributeName) {
        return this.removeAttribute(this.getIAttribute(attributeName));
    }

    @Override
    public void removeMark(IMark mark) {
        MarkData data = MarkData.get((EntityLivingBase)this.entity);
        data.marks.remove((MarkData.Mark)mark);
        data.syncClients();
    }

    @Override
    public void setArmor(int slot, IItemStack item) {
        if (slot < 0 || slot > 3) {
            throw new CustomNPCsException("Wrong slot id:" + slot, new Object[0]);
        }
        EntityEquipmentSlot s = this.getSlot(slot);
        if (s != null) {
            ((EntityLivingBase)this.entity).func_184201_a(s, item == null ? ItemStack.field_190927_a : item.getMCItemStack());
        }
    }

    public void setAttackTarget(IEntityLivingBase living) {
        if (living == null) {
            ((EntityLivingBase)this.entity).func_70604_c(null);
        } else {
            ((EntityLivingBase)this.entity).func_70604_c(living.getMCEntity());
        }
    }

    @Override
    public void setHealth(float health) {
        ((EntityLivingBase)this.entity).func_70606_j(health);
    }

    @Override
    public void setMainhandItem(IItemStack item) {
        ((EntityLivingBase)this.entity).func_184611_a(EnumHand.MAIN_HAND, item == null ? ItemStack.field_190927_a : item.getMCItemStack());
    }

    @Override
    public void setMaxHealth(float health) {
        if (health < 0.0f) {
            return;
        }
        ((EntityLivingBase)this.entity).func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)health);
    }

    @Override
    public void setMoveForward(float move) {
        ((EntityLivingBase)this.entity).field_191988_bg = move;
    }

    @Override
    public void setMoveStrafing(float move) {
        ((EntityLivingBase)this.entity).field_70702_br = move;
    }

    @Override
    public void setMoveVertical(float move) {
        ((EntityLivingBase)this.entity).field_70701_bs = move;
    }

    @Override
    public void setOffhandItem(IItemStack item) {
        ((EntityLivingBase)this.entity).func_184611_a(EnumHand.OFF_HAND, item == null ? ItemStack.field_190927_a : item.getMCItemStack());
    }

    private void swim(EnumHand hand) {
        if (!(this.entity instanceof EntityPlayerMP)) {
            ((EntityLivingBase)this.entity).func_184609_a(hand);
            return;
        }
        ItemStack stack = ((EntityLivingBase)this.entity).func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b().onEntitySwing((EntityLivingBase)this.entity, stack)) {
            return;
        }
        if (!((EntityLivingBase)this.entity).field_82175_bq || ((EntityLivingBase)this.entity).field_110158_av >= this.getArmSwingAnimationEnd() / 2 || ((EntityLivingBase)this.entity).field_110158_av < 0) {
            ((EntityLivingBase)this.entity).field_110158_av = -1;
            ((EntityLivingBase)this.entity).field_82175_bq = true;
            ((EntityLivingBase)this.entity).field_184622_au = hand;
            SPacketAnimation pack = new SPacketAnimation(this.entity, hand == EnumHand.MAIN_HAND ? 0 : 3);
            IntHashMap<EntityTrackerEntry> trackedEntityHashTable = ((IEntityTrackerMixin)((WorldServer)((EntityLivingBase)this.entity).field_70170_p).func_73039_n()).npcs$getTrackedEntityHashTable();
            EntityTrackerEntry entitytrackerentry = (EntityTrackerEntry)trackedEntityHashTable.func_76041_a(((EntityLivingBase)this.entity).func_145782_y());
            if (entitytrackerentry != null) {
                for (EntityPlayerMP entityplayermp : entitytrackerentry.field_73134_o) {
                    entityplayermp.field_71135_a.func_147359_a((Packet)pack);
                }
                if (this.entity instanceof EntityPlayerMP && !entitytrackerentry.field_73134_o.contains((EntityPlayerMP)this.entity)) {
                    ((EntityPlayerMP)this.entity).field_71135_a.func_147359_a((Packet)pack);
                }
            }
        }
    }

    @Override
    public void swingMainhand() {
        this.swim(EnumHand.MAIN_HAND);
    }

    @Override
    public void swingOffhand() {
        this.swim(EnumHand.OFF_HAND);
    }

    @Override
    public boolean typeOf(int type) {
        return type == EntityType.LIVING.get() || super.typeOf(type);
    }
}

